DROP PROCEDURE [hips].[HospitalContactGet]
GO
SET ANSI_NULLS ON
GO
SET QUOTED_IDENTIFIER ON
GO
-- =============================================
-- Author:        Simon Biber
-- Create date:   18 July 2012
-- Description:   Gets hospital contact records from the joined Contact and HospitalContact tables
-- Modified:
-- Philip Stalley-Gordon -  3 April 2013 - Make HospitalId optional and return HospitalId
-- Simon Biber           - 24 April 2013 - Cleaned up comments
-- Simon Biber           - 28 May 2013 - Return Description as ContactMethodDescription
-- =============================================
CREATE PROCEDURE [hips].[HospitalContactGet] 
(
	 @HospitalId INT = NULL
) AS

BEGIN
SELECT  c.ContactId,
		c.Detail,
		c.ContactMethodId,
		cm.TelecommunicationType,
		cm.Description AS ContactMethodDescription,
		cm.CdaType,
		c.DateCreated,
		c.UserCreated,
		c.DateModified,
		c.UserModified,
		hc.HospitalId			
FROM hips.Contact c
INNER JOIN hips.ContactMethod AS cm ON cm.ContactMethodId = c.ContactMethodId
INNER JOIN hips.HospitalContact as hc On hc.ContactId = c.ContactId
WHERE (@HospitalId IS NULL OR hc.HospitalId = @HospitalId)

END
GO

